package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.DocumentoAperturasDaoImpl;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * Ab0465s00DaoImpl generated by UDA, 15-Feb-2017 09:14:46.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoAperturasCustomDaoImpl extends DocumentoAperturasDaoImpl
		implements DocumentoAperturasCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_065 IDDOCUMENTO065, t1.ID_TRAMITE_APERTURAS_065 IDTRAMITEAPERTURAS065, t1.ORIGEN_065 ORIGEN065, t1.FECHA_DOC_065 FECHADOC065, "
			+ "t1.RUTA_PIF_065 RUTAPIF065, t1.NOMBRE_DOC_065 NOMBREDOC065, t1.OID_DOKUSI_065 OIDDOKUSI065, t1.ID_TIPO_DOC_065 IDTIPODOC065, t1.FORMATO_APORT_065 FORMATOAPORT065,"
			+ " t1.ID_TAREA_CONT_065 IDTAREACONT065, t1.ID_DATOS_ENVIO_POSTAL_065 IDDATOSENVIOPOSTAL065, t1.DESCRIPCION_ES_091 DESCRIPCIONES091, t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, "
			+ "t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, t1.APORT_GEN_091 APORTGEN091 FROM VDOCUMENTO_APERTURAS_TIPO t1 ";

	private static final String QUERY_SELECT_COLUMNAS = "SELECT t1.ID_TIPO_DOC_091 IDTIPODOC091,t1.DESCRIPCION_ES_091 DESCRIPCIONES091,"
			+ " t1.DESCRIPCION_EU_091 DESCRIPCIONEU091, t1.TIPO_DOKUSI_091 TIPODOKUSI091, t1.ASUNTO_DOKUSI_091 ASUNTODOKUSI091, "
			+ " t2.FORMATO_APORT_065 FORMATOAPORT065, t1.APORT_GEN_091 APORTGEN091, t2.ID_DOCUMENTO_065 IDDOCUMENTO065, t2.ID_TRAMITE_APERTURAS_065 IDTRAMITEAPERTURAS065, "
			+ "t2.FECHA_DOC_065 FECHADOC065, t2.OID_DOKUSI_065 OIDDOKUSI065, t2.ID_TIPO_DOC_065 IDTIPODOC065, t2.ID_TAREA_CONT_065 IDTAREACONT065, t2.ID_DATOS_ENVIO_POSTAL_065 IDDATOSENVIOPOSTAL065, "
			+ "t2.ORIGEN_065 ORIGEN065, t2.RUTA_PIF_065 RUTAPIF065, t2.NOMBRE_DOC_065 NOMBREDOC065, t2.ID_TIPO_DOC_065 IDTIPODOC065 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoAperturas> rwMap = new RowMapper<DocumentoAperturas>() {
		public DocumentoAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoAperturas documento = new DocumentoAperturas(
					resultSet.getLong("IDDOCUMENTO065"),
					new TramiteAperturas(
							resultSet.getLong("IDTRAMITEAPERTURAS065")),
					resultSet.getInt("ORIGEN065"),
					resultSet.getDate("FECHADOC065"),
					resultSet.getString("RUTAPIF065"),
					resultSet.getString("NOMBREDOC065"),
					resultSet.getString("OIDDOKUSI065"), null,
					resultSet.getString("FORMATOAPORT065"));

			documento
					.setTipoDocumento(
							new TipoDocumento(
									(resultSet.getLong("IDTIPODOC065") == 0
											? resultSet.getLong("IDTIPODOC091")
											: resultSet
													.getLong("IDTIPODOC065")),
									resultSet.getString("DESCRIPCIONES091"),
									resultSet.getString("DESCRIPCIONEU091"),
									resultSet.getString("TIPODOKUSI091"),
									resultSet.getString("ASUNTODOKUSI091"),
									resultSet.getString("APORTGEN091")));

			Long idTareaContinuar = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDTAREACONT065");
			if (idTareaContinuar != null) {
				documento.setTareaAperturasContinuar(
						new TareaAperturas(idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDDATOSENVIOPOSTAL065");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(
						new DatosEnvioPostal(idDatosEnvioPostal));
			}

			return documento;
		}
	};

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  Ab0465s00
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the documento aperturas
	 */
	@Transactional(readOnly = true)
	public DocumentoAperturas vfind(DocumentoAperturas ab0465s00) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_065 = ? ");

		List<DocumentoAperturas> ab0465s00List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, ab0465s00.getIdDocumento065());
		return (DocumentoAperturas) DataAccessUtils.uniqueResult(ab0465s00List);
	}

	/**
	 * Finds a list of rows in the Ab0465s00 table.
	 * 
	 *  ab0465s00
	 *            Ab0465s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0465s00>
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> vfindAll(DocumentoAperturas ab0465s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasCustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0465s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoAperturas>) this.getJdbcTemplate()
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 *  documento
	 *            SolicDocAperturas
	 * 
	 *  List<SolicDocAperturas>.
	 *
	 * @param documento the documento
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoAperturas> buscarDocumentosAperturasTipo(
			DocumentoAperturas documento) {
		StringBuilder query = new StringBuilder(
				DocumentoAperturasCustomDaoImpl.QUERY_SELECT_COLUMNAS);
		query.append(
				" FROM AB0491S00 t1 LEFT JOIN AB0465S00 t2 ON  t2.ID_TIPO_DOC_065  = t1.ID_TIPO_DOC_091 ");
		query.append(" AND t2.ID_TRAMITE_APERTURAS_065 = ? ");
		// query.append(" order by idtipodoc091 ");

		return (List<DocumentoAperturas>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap,
				documento.getTramiteAperturas().getIdTramite062());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0465s00 entity
	 * 
	 *  ab0465s00
	 *            Ab0465s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0465s00 the ab 0465 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoAperturas ab0465s00) {

		StringBuilder where = new StringBuilder(
				DocumentoAperturasCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0465s00 != null && ab0465s00.getIdDocumento065() != null) {
			where.append(" AND t1.ID_DOCUMENTO_065 = ?");
			params.add(ab0465s00.getIdDocumento065());
		}
		if (ab0465s00 != null && ab0465s00.getTramiteAperturas() != null
				&& ab0465s00.getTramiteAperturas().getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_APERTURAS_065 = ?");
			params.add(ab0465s00.getTramiteAperturas().getIdTramite062());
		}
		if (ab0465s00 != null && ab0465s00.getOrigen065() != null) {
			where.append(" AND t1.ORIGEN_065 = ?");
			params.add(ab0465s00.getOrigen065());
		}
		if (ab0465s00 != null && ab0465s00.getFechaDoc065() != null) {
			where.append(" AND t1.FECHA_DOC_065 = ?");
			params.add(ab0465s00.getFechaDoc065());
		}
		if (ab0465s00 != null && ab0465s00.getRutaPif065() != null) {
			where.append(" AND t1.RUTA_PIF_065 = ?");
			params.add(ab0465s00.getRutaPif065());
		}
		if (ab0465s00 != null && ab0465s00.getNombreDoc065() != null) {
			where.append(" AND t1.NOMBRE_DOC_065 = ?");
			params.add(ab0465s00.getNombreDoc065());
		}
		if (ab0465s00 != null && ab0465s00.getOidDokusi065() != null) {
			where.append(" AND t1.OID_DOKUSI_065 = ?");
			params.add(ab0465s00.getOidDokusi065());
		}

		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_065 = ?");
			params.add(ab0465s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getDescripcionEs091() != null) {
			where.append(" AND t1.DESCRIPCION_ES_091 = ?");
			params.add(ab0465s00.getTipoDocumento().getDescripcionEs091());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getDescripcionEu091() != null) {
			where.append(" AND t1.DESCRIPCION_EU_091 = ?");
			params.add(ab0465s00.getTipoDocumento().getDescripcionEu091());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getTipoDokusi091() != null) {
			where.append(" AND t1.TIPO_DOKUSI_091 = ?");
			params.add(ab0465s00.getTipoDocumento().getTipoDokusi091());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getAsuntoDokusi091() != null) {
			where.append(" AND t1.ASUNTO_DOKUSI_091 = ?");
			params.add(ab0465s00.getTipoDocumento().getAsuntoDokusi091());
		}
		if (ab0465s00 != null && ab0465s00.getTipoDocumento() != null
				&& ab0465s00.getTipoDocumento().getAportGen091() != null) {
			where.append(" AND t1.APORT_GEN_091 = ?");
			params.add(ab0465s00.getTipoDocumento().getAportGen091());
		}
		if (ab0465s00 != null && ab0465s00.getFormatoAport065() != null) {
			where.append(" AND t1.FORMATO_APORT_065 = ?");
			params.add(ab0465s00.getFormatoAport065());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
